---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Ontologically Disconnected

> Interfaces are closed or absent; no paths exist; the exterior is perceived as Void.

---

## Definition

- Closed interface state
- Path absent check
- Void observable
- Block pattern

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Closed check | Port blocked | `Monitor`, `Closed` |
| No path | Link dead | `Check`, `Block` |
| Void view | Space dark | `Test`, `Void` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Closed check | Way blocked | "Can't reach" |
| No path | Can't move | "No path" |
| Void view | Space gone | "See void" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Port blocked | Way blocked | How closed works |
| Link dead | Can't move | How block flows |
| Space dark | Space gone | How void forms |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Force block | Energy void |
| Networks | Link closed | Node block |
| Cognition | Mind void | Think block |
| Systems | Flow closed | Move void |

---

## Scale Effects

How Disconnection manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum block | Wave closed |
| λV | Gate void | State block |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase closed | Pattern block |
| ∇S | Structure void | Clear closed |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave block | Light closed |
| λV | Field closed | Space block |

Note: At extreme scales, disconnection faces fundamental limits (e.g., quantum closure at ε, causal blocks at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: closed clarity
- c: block speed
- ψA: phase void
- λV: gate closed

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern closed | Wave block |
| Human | λV | Gate void | Flow closed |
| Cosmic | ψA | Phase block | Field closed |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Closed leak | Pattern pass | Way through |
| Human | Block fail | Flow leak | Can move |
| Cosmic | Void breach | Space pass | No block |

---

## Diagnostic Checklist

Technical tests:
- [ ] Closed checked
- [ ] Block works
- [ ] Void seen
- [ ] Stop flows

Humane tests:
- [ ] Way blocked
- [ ] Can't move
- [ ] Space gone
- [ ] Flow stops

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical disconnection nor experiential blockage alone captures its full meaning.

---

## See Also

- [[Ontologically Connected]]
- [[Void]]
- [[Field]]
- [[Path (chain) (pattern)]]
- [[Bridge : Articulation (relation)]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented